/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.containeraccessor.components;

import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import ru.ilb.containeraccessor.components.ContainerResourceIndex$AjcClosure1;
import ru.ilb.containeraccessor.components.FileResource;
import ru.ilb.containeraccessor.core.ContainerAccessor;
import ru.ilb.containeraccessor.core.ContainerAccessorFactory;
import ru.ilb.containeraccessor.mapper.FileMapper;
import ru.ilb.containeraccessor.mapper.FileMapperJson;
import ru.ilb.containeraccessor.model.File;
import ru.ilb.uriaccessor.URIAccessor;
import ru.ilb.uriaccessor.URIAccessorFactory;
import ru.ilb.uriaccessor.URIStorage;

public class ContainerResourceIndex
implements FileResource {
    private final FileMapper fileMapper = new FileMapperJson();
    private final URIAccessor uriAccessor;
    private final URIAccessorFactory uriAccessorFactory = new URIAccessorFactory();
    private final ContainerAccessorFactory caf = new ContainerAccessorFactory();
    private final ContainerAccessor containerAccessor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ContainerResourceIndex(URI uri, URIStorage uriStorage) {
        this.uriAccessor = this.uriAccessorFactory.getURIAccessor(uri);
        this.containerAccessor = this.caf.getContainerAccessor(this.uriAccessor);
    }

    @Override
    @Loggable(value=2)
    public Response get(String accept) throws IOException {
        String string = accept;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Response)MethodLogger.aspectOf().wrapMethod(new ContainerResourceIndex$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        ContainerResourceIndex.ajc$preClinit();
    }

    static final /* synthetic */ Response get_aroundBody0(ContainerResourceIndex ajc$this, String accept, JoinPoint joinPoint) {
        if (accept != null && !accept.startsWith("application/json")) {
            throw new WebApplicationException("MediaType " + accept + " not supported");
        }
        ArrayList files = new ArrayList();
        Files.list(ajc$this.containerAccessor.getContentsPath()).sorted().forEach(x -> {
            File file = new File();
            file.setName(x.getFileName().toString());
            LocalDateTime date = Instant.ofEpochSecond(x.toFile().lastModified() / 1000L).atZone(ZoneId.systemDefault()).toLocalDateTime();
            file.setLastModified(date);
            file.setSize(x.toFile().length());
            files.add(file);
        });
        String json = ajc$this.fileMapper.marshall(files);
        return Response.ok((Object)json, (String)"application/json").build();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerResourceIndex.java", ContainerResourceIndex.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "ru.ilb.containeraccessor.components.ContainerResourceIndex", "java.lang.String", "accept", "java.io.IOException", "javax.ws.rs.core.Response"), 64);
    }
}

