/**
 * Created by Apache CXF WadlToJava code generator
**/
package ru.ilb.filedossier.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import ru.ilb.filedossier.core.ContentDispositionMode;

public interface DossierFileResource {

    /**
     * get dossier file contents
     */
    @GET
    @Produces("*/*")
    Response download(@QueryParam("version") Integer version, @QueryParam("mode") @DefaultValue("attachment") ContentDispositionMode mode, @HeaderParam("accept") String accept);

    /**
     * test
     */
    @GET
    @Path("/container")
    Response container(@QueryParam("path") String path);

    /**
     * add file to current dossier file version
     */
    @POST
    @Consumes("multipart/form-data")
    @Path("/update")
    void update(MultipartBody body);

    /**
     * create new dossier file version
     */
    @POST
    @Consumes("multipart/form-data")
    @Path("/publish")
    void publish(MultipartBody body);

    @Path("/context")
    DossierContextResource getDossierContextResource();

}