
package ru.ilb.filedossier.view;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Link;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.migesok.jaxb.adapter.javatime.LocalDateTimeXmlAdapter;
import ru.ilb.filedossier.api.JaxbLink;
import ru.ilb.filedossier.api.LinkAdapter;


/**
 * Файл досье
 * 
 * <p>Java class for dossierFile complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="dossierFile"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="link" type="{http://www.w3.org/2001/XMLSchema}anyType" maxOccurs="unbounded"/&gt;
 *         &lt;element name="code" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="exists" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="readonly" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="required" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="hidden" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="mediaType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="allowedMultiple" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="allowedMediaTypes" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded"/&gt;
 *         &lt;element name="version" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="lastModified" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "dossierFile", propOrder = {
    "links",
    "code",
    "name",
    "exists",
    "readonly",
    "required",
    "hidden",
    "mediaType",
    "allowedMultiple",
    "allowedMediaTypes",
    "version",
    "lastModified"
})
@XmlRootElement(name = "dossierFile")
public class DossierFileView
    implements Serializable
{

    @XmlElement(name = "link", required = true, type = JaxbLink.class)
    @XmlJavaTypeAdapter(LinkAdapter.class)
    protected List<Link> links;
    /**
     * Код файла
     * 
     */
    @XmlElement(required = true)
    protected String code;
    /**
     * Наименование
     * 
     */
    @XmlElement(required = true)
    protected String name;
    /**
     * Наличие
     * 
     */
    protected boolean exists;
    /**
     * Только для чтения
     * 
     */
    protected boolean readonly;
    /**
     * Обязательный
     * 
     */
    protected boolean required;
    /**
     * Скрытый
     * 
     */
    protected boolean hidden;
    /**
     * Тип файла
     * 
     */
    @XmlElement(required = true)
    protected String mediaType;
    /**
     * Разрешена одновременная загрузка нескольких файлов
     * 
     */
    protected boolean allowedMultiple;
    /**
     * Разрешенные для загрузки типы файлов
     * 
     */
    @XmlElement(required = true)
    protected List<String> allowedMediaTypes;
    /**
     * Версия файла
     * 
     */
    protected String version;
    /**
     * Время последней модификации
     * 
     */
    @XmlElement(required = true, type = String.class)
    @XmlJavaTypeAdapter(LocalDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    protected LocalDateTime lastModified;

    /**
     * Gets the value of the links property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the links property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLinks().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    public List<Link> getLinks() {
        if (links == null) {
            links = new ArrayList<Link>();
        }
        return this.links;
    }

    /**
     * Gets the value of the code property.
     * <p>
     * Код файла
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCode() {
        return code;
    }

    /**
     * Sets the value of the code property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCode()
     */
    public void setCode(String value) {
        this.code = value;
    }

    /**
     * Gets the value of the name property.
     * <p>
     * Наименование
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the exists property.
     * <p>
     * Наличие
     * 
     */
    public boolean isExists() {
        return exists;
    }

    /**
     * Sets the value of the exists property.
     * 
     * @see #isExists()
     */
    public void setExists(boolean value) {
        this.exists = value;
    }

    /**
     * Gets the value of the readonly property.
     * <p>
     * Только для чтения
     * 
     */
    public boolean isReadonly() {
        return readonly;
    }

    /**
     * Sets the value of the readonly property.
     * 
     * @see #isReadonly()
     */
    public void setReadonly(boolean value) {
        this.readonly = value;
    }

    /**
     * Gets the value of the required property.
     * <p>
     * Обязательный
     * 
     */
    public boolean isRequired() {
        return required;
    }

    /**
     * Sets the value of the required property.
     * 
     * @see #isRequired()
     */
    public void setRequired(boolean value) {
        this.required = value;
    }

    /**
     * Gets the value of the hidden property.
     * <p>
     * Скрытый
     * 
     */
    public boolean isHidden() {
        return hidden;
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @see #isHidden()
     */
    public void setHidden(boolean value) {
        this.hidden = value;
    }

    /**
     * Gets the value of the mediaType property.
     * <p>
     * Тип файла
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMediaType() {
        return mediaType;
    }

    /**
     * Sets the value of the mediaType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getMediaType()
     */
    public void setMediaType(String value) {
        this.mediaType = value;
    }

    /**
     * Gets the value of the allowedMultiple property.
     * <p>
     * Разрешена одновременная загрузка нескольких файлов
     * 
     */
    public boolean isAllowedMultiple() {
        return allowedMultiple;
    }

    /**
     * Sets the value of the allowedMultiple property.
     * 
     * @see #isAllowedMultiple()
     */
    public void setAllowedMultiple(boolean value) {
        this.allowedMultiple = value;
    }

    /**
     * Gets the value of the allowedMediaTypes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the allowedMediaTypes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAllowedMediaTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * <p>
     * Разрешенные для загрузки типы файлов
     * 
     */
    public List<String> getAllowedMediaTypes() {
        if (allowedMediaTypes == null) {
            allowedMediaTypes = new ArrayList<String>();
        }
        return this.allowedMediaTypes;
    }

    /**
     * Gets the value of the version property.
     * <p>
     * Версия файла
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVersion()
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * Gets the value of the lastModified property.
     * <p>
     * Время последней модификации
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public LocalDateTime getLastModified() {
        return lastModified;
    }

    /**
     * Sets the value of the lastModified property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLastModified()
     */
    public void setLastModified(LocalDateTime value) {
        this.lastModified = value;
    }

    public void setLinks(List<Link> value) {
        this.links = value;
    }

    public void setAllowedMediaTypes(List<String> value) {
        this.allowedMediaTypes = value;
    }

    public DossierFileView withLinks(Link... values) {
        if (values!= null) {
            for (Link value: values) {
                getLinks().add(value);
            }
        }
        return this;
    }

    public DossierFileView withLinks(Collection<Link> values) {
        if (values!= null) {
            getLinks().addAll(values);
        }
        return this;
    }

    public DossierFileView withCode(String value) {
        setCode(value);
        return this;
    }

    public DossierFileView withName(String value) {
        setName(value);
        return this;
    }

    public DossierFileView withExists(boolean value) {
        setExists(value);
        return this;
    }

    public DossierFileView withReadonly(boolean value) {
        setReadonly(value);
        return this;
    }

    public DossierFileView withRequired(boolean value) {
        setRequired(value);
        return this;
    }

    public DossierFileView withHidden(boolean value) {
        setHidden(value);
        return this;
    }

    public DossierFileView withMediaType(String value) {
        setMediaType(value);
        return this;
    }

    public DossierFileView withAllowedMultiple(boolean value) {
        setAllowedMultiple(value);
        return this;
    }

    public DossierFileView withAllowedMediaTypes(String... values) {
        if (values!= null) {
            for (String value: values) {
                getAllowedMediaTypes().add(value);
            }
        }
        return this;
    }

    public DossierFileView withAllowedMediaTypes(Collection<String> values) {
        if (values!= null) {
            getAllowedMediaTypes().addAll(values);
        }
        return this;
    }

    public DossierFileView withVersion(String value) {
        setVersion(value);
        return this;
    }

    public DossierFileView withLastModified(LocalDateTime value) {
        setLastModified(value);
        return this;
    }

    public DossierFileView withLinks(List<Link> value) {
        setLinks(value);
        return this;
    }

    public DossierFileView withAllowedMediaTypes(List<String> value) {
        setAllowedMediaTypes(value);
        return this;
    }

}
