/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.barcode.functions;

import com.drew.imaging.ImageProcessingException;
import java.io.IOException;
import java.util.Optional;
import ru.ilb.filedossier.barcode.entities.Barcode;
import ru.ilb.filedossier.barcode.functions.BarcodeScannerFunction;
import ru.ilb.filedossier.metadata.extractor.ImageUtils;

public class XmpBarcodeScannerFunction
implements BarcodeScannerFunction {
    @Override
    public Optional<Barcode> apply(byte[] t) {
        String barcode = null;
        try {
            barcode = ImageUtils.extractXMPMetadata((byte[])t, (String)"barcode");
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting image to scan" + e);
        }
        catch (ImageProcessingException e) {
            throw new RuntimeException("Error while barcode scanning" + (Object)((Object)e));
        }
        if (barcode == null) {
            return Optional.empty();
        }
        return Optional.of(new Barcode(barcode));
    }
}

