/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.components;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.springframework.context.ApplicationContext;
import ru.ilb.filedossier.api.DossierContextResource;
import ru.ilb.filedossier.api.DossierFileResource;
import ru.ilb.filedossier.components.DossierContextResourceImpl;
import ru.ilb.filedossier.contentnegotiation.sevice.ContentNegotiationSevice;
import ru.ilb.filedossier.core.ContentDispositionMode;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierFileVersion;
import ru.ilb.filedossier.entities.Representation;
import ru.ilb.filedossier.exceptions.NotAcceptableMediaType;
import ru.ilb.filedossier.filedossier.usecases.upload.PublishFile;
import ru.ilb.filedossier.filedossier.usecases.upload.PublishFileNewVersion;
import ru.ilb.uriaccessor.URIStorageFactory;

public class DossierFileResourceImpl
implements DossierFileResource {
    @Inject
    private PublishFile publishFile;
    @Inject
    private PublishFileNewVersion publishFileNewVersion;
    @Inject
    private ApplicationContext applicationContext;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ContentNegotiationSevice contentNegotiationSevice;
    private final URIStorageFactory uriStorageFactory = new URIStorageFactory();
    private DossierFile dossierFile;

    final void setDossierFile(DossierFile dossierFile) {
        this.dossierFile = dossierFile;
    }

    public Response download(Integer version, ContentDispositionMode mode, String accept) {
        DossierFileVersion dossierFileVersion = version == null ? this.dossierFile.getLatestVersion() : this.dossierFile.getVersion(version.intValue());
        if (dossierFileVersion == null) {
            return null;
        }
        List allowedMediaTypes = dossierFileVersion.getAllowedMediaTypes();
        String acceptableMediaType = (String)this.contentNegotiationSevice.getAcceptableMediaType(accept, allowedMediaTypes).orElseThrow(() -> new NotAcceptableMediaType(allowedMediaTypes));
        Representation representation = dossierFileVersion.getRepresentation(acceptableMediaType);
        String contentDisposition = ContentDispositionMode.ATTACHMENT.equals((Object)mode) ? mode.value() + "; filename=" + representation.getFileName() : mode.value();
        try {
            byte[] contents = representation.getContents();
            return Response.ok((Object)contents).header("Content-Size", (Object)contents.length).header("Content-Type", (Object)representation.getMediaType()).header("Content-Disposition", (Object)contentDisposition).build();
        }
        catch (IOException e) {
            throw new RuntimeException("can not load representation: " + e);
        }
    }

    public void update(MultipartBody body) {
        if (body.getAllAttachments().isEmpty()) {
            throw new WebApplicationException("Upload empty");
        }
        if (body.getAllAttachments().size() < 1) {
            this.publishFile.publish((File)body.getRootAttachment().getObject(File.class), this.dossierFile);
        } else {
            this.publishFile.mergeAndPublish(body.getAllAttachments().stream().map(att -> (File)att.getObject(File.class)).collect(Collectors.toList()), this.dossierFile);
        }
    }

    public void publish(MultipartBody body) {
        if (body.getAllAttachments().isEmpty()) {
            throw new WebApplicationException("Upload empty");
        }
        if (body.getAllAttachments().size() < 1) {
            this.publishFileNewVersion.publish((File)body.getRootAttachment().getObject(File.class), this.dossierFile);
        } else {
            this.publishFileNewVersion.mergeAndPublish(body.getAllAttachments().stream().map(att -> (File)att.getObject(File.class)).collect(Collectors.toList()), this.dossierFile);
        }
    }

    public DossierContextResource getDossierContextResource() {
        DossierContextResourceImpl resource = new DossierContextResourceImpl();
        resource.setContextKey(this.dossierFile.getContextKey());
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)resource);
        return (DossierContextResource)this.resourceContext.initResource((Object)resource);
    }

    public Response container(String path) {
        StringBuilder redirect = new StringBuilder(100);
        redirect.append("containers/");
        redirect.append(this.uriStorageFactory.getURIStorage().registerUri(this.dossierFile.getLatestVersion().getFilePath().toUri(), this.dossierFile.getLatestVersion().getMediaType()));
        if (path != null && !path.isEmpty()) {
            if (!path.startsWith("/")) {
                redirect.append("/");
            }
            redirect.append(path);
        }
        return Response.seeOther((URI)URI.create(redirect.toString())).build();
    }
}

