/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.components;

import javax.inject.Inject;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.context.ApplicationContext;
import ru.ilb.filedossier.api.DossierFileResource;
import ru.ilb.filedossier.api.DossierResource;
import ru.ilb.filedossier.api.DossierStoreResource;
import ru.ilb.filedossier.components.DossierFileResourceImpl;
import ru.ilb.filedossier.entities.Dossier;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.mappers.DossierMapper;
import ru.ilb.filedossier.view.DossierView;

public class DossierResourceImpl
implements DossierResource {
    @Inject
    private DossierMapper dossierMapper;
    @Inject
    private ApplicationContext applicationContext;
    @Context
    private ResourceContext resourceContext;
    @Context
    private UriInfo uriInfo;
    private Dossier dossier;

    final void setDossier(Dossier dossier) {
        this.dossier = dossier;
    }

    public DossierView getDossier() {
        return this.dossierMapper.map(this.dossier, this.uriInfo.getRequestUri());
    }

    public DossierFileResource getDossierFileResource(String fileCode) {
        DossierFile dossierFile = this.dossier.getDossierFile(fileCode);
        DossierFileResourceImpl resource = new DossierFileResourceImpl();
        resource.setDossierFile(dossierFile);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)resource);
        return (DossierFileResource)this.resourceContext.initResource((Object)resource);
    }

    public DossierStoreResource getDossierStoreResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

