/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.mappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import ru.ilb.filedossier.core.ContentDispositionMode;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierFileVersion;
import ru.ilb.filedossier.mappers.DossierFileMapper;
import ru.ilb.filedossier.view.DossierFileView;

@Named
public class DossierFileMapperImpl
implements DossierFileMapper {
    @Override
    public DossierFileView map(DossierFile model, URI dossierFileResourceUri) {
        DossierFileView df = new DossierFileView();
        df.setCode(model.getCode());
        df.setName(model.getName());
        df.setExists(model.getExists());
        df.setReadonly(model.getReadonly());
        df.setRequired(model.getRequired());
        df.setHidden(model.getHidden());
        df.setAllowedMultiple(model.getAllowedMultiple());
        df.setAllowedMediaTypes(model.getAllowedMediaTypes());
        df.setLinks(this.buildDossierFileLinks(dossierFileResourceUri));
        if (model.getExists()) {
            DossierFileVersion latestVersion = model.getLatestVersion();
            df.setVersion(String.valueOf(model.getVersionsCount()));
            df.setMediaType(latestVersion.getMediaType());
            df.setLastModified(model.lastModified());
        }
        return df;
    }

    private List<Link> buildDossierFileLinks(URI dossierFileResourceUri) {
        ArrayList<Link> links = new ArrayList<Link>();
        Stream.of(ContentDispositionMode.values()).forEach(mode -> {
            Link link = Link.fromUri((URI)this.addParamToUri(dossierFileResourceUri, "mode", mode.value())).rel(mode.value()).build(new Object[0]);
            links.add(link);
        });
        Link update = Link.fromUri((URI)UriBuilder.fromUri((URI)dossierFileResourceUri).path("update").build(new Object[0])).rel("update").build(new Object[0]);
        links.add(update);
        Link publish = Link.fromUri((URI)UriBuilder.fromUri((URI)dossierFileResourceUri).path("publish").build(new Object[0])).rel("publish").build(new Object[0]);
        links.add(publish);
        Link context = Link.fromUri((URI)UriBuilder.fromUri((URI)dossierFileResourceUri).path("context").build(new Object[0])).rel("context").build(new Object[0]);
        links.add(context);
        Link container = Link.fromUri((URI)UriBuilder.fromUri((URI)dossierFileResourceUri).path("container").build(new Object[0])).rel("container").build(new Object[0]);
        links.add(container);
        return links;
    }

    private URI addParamToUri(URI uri, String name, Object ... params) {
        return UriBuilder.fromUri((URI)uri).queryParam(name, params).build(new Object[0]);
    }
}

