/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.mappers;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import ru.ilb.filedossier.api.DossierResource;
import ru.ilb.filedossier.entities.Dossier;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.mappers.DossierFileMapper;
import ru.ilb.filedossier.mappers.DossierMapper;
import ru.ilb.filedossier.view.DossierFileView;
import ru.ilb.filedossier.view.DossierView;

@Named
public class DossierMapperImpl
implements DossierMapper {
    private final DossierFileMapper dossierFileMapper;

    @Inject
    public DossierMapperImpl(DossierFileMapper dossierFileMapper) {
        this.dossierFileMapper = dossierFileMapper;
    }

    @Override
    public DossierView map(Dossier model, URI dossierResourceUri) {
        DossierView view = new DossierView();
        view.setCode(model.getCode());
        view.setName(model.getName());
        view.setValid(String.valueOf(model.isValid()));
        view.setDossierFiles(this.buildDossierFiles(model.getDossierFiles(), dossierResourceUri));
        return view;
    }

    private List<DossierFileView> buildDossierFiles(List<DossierFile> dossierFilesModels, URI dossierResourceUri) {
        return dossierFilesModels.stream().map(fileModel -> this.dossierFileMapper.map((DossierFile)fileModel, this.getDossierFileResourceUri(dossierResourceUri, fileModel.getCode()))).collect(Collectors.toList());
    }

    private URI getDossierFileResourceUri(URI baseUri, String code) {
        return UriBuilder.fromUri((URI)baseUri).path(DossierResource.class, "getDossierFileResource").resolveTemplate("fileCode", (Object)code).build(new Object[0]);
    }
}

