/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.contentnegotiation.domain;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import ru.ilb.filedossier.contentnegotiation.domain.MediaTypeQComparator;

public class MediaTypeAcceptor {
    private final List<MediaType> acceptableMediaTypes;
    private final boolean acceptDefaultRepresentation;

    public MediaTypeAcceptor(String acceptableMediaTypes) {
        this(Stream.of(acceptableMediaTypes.split(",")).map(mt -> MediaType.valueOf((String)mt)).collect(Collectors.toList()));
    }

    public MediaTypeAcceptor(List<MediaType> acceptableMediaTypes) {
        this.acceptableMediaTypes = acceptableMediaTypes;
        this.acceptDefaultRepresentation = acceptableMediaTypes.stream().anyMatch(mt -> mt.toString().equals("text/html"));
    }

    public Optional<MediaType> getCompatibleMediaType(MediaType other) {
        return this.acceptableMediaTypes.stream().filter(mt -> mt.isCompatible(other)).sorted(MediaTypeQComparator.INSTANCE.reversed()).findFirst();
    }

    public boolean isAcceptDefaultRepresentation() {
        return this.acceptDefaultRepresentation;
    }
}

