/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.contentnegotiation.domain;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import ru.ilb.filedossier.contentnegotiation.domain.MediaTypeAcceptor;
import ru.ilb.filedossier.contentnegotiation.domain.MediaTypeQComparator;

public class MediaTypeResolver {
    private final MediaTypeAcceptor mediaTypeAcceptor;

    public MediaTypeResolver(MediaTypeAcceptor mediaTypeAcceptor) {
        this.mediaTypeAcceptor = mediaTypeAcceptor;
    }

    public Optional<MediaType> getAcceptableMediaType(List<MediaType> allowedMediaTypes) {
        if (this.mediaTypeAcceptor.isAcceptDefaultRepresentation()) {
            return Optional.ofNullable(allowedMediaTypes.get(0));
        }
        return allowedMediaTypes.stream().flatMap(allowed -> MediaTypeResolver.streamopt(this.mediaTypeAcceptor.getCompatibleMediaType((MediaType)allowed).map(acceptable -> MediaTypeResolver.combineMediaType(allowed, acceptable)))).sorted(MediaTypeQComparator.INSTANCE.reversed()).findFirst();
    }

    private static MediaType combineMediaType(MediaType allowed, MediaType acceptable) {
        return new MediaType(allowed.getType(), allowed.getSubtype(), acceptable.getParameters());
    }

    private static <T> Stream<T> streamopt(Optional<T> opt) {
        return opt.map(Stream::of).orElse(Stream.empty());
    }
}

