/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.context;

import java.util.Optional;
import ru.ilb.filedossier.context.DossierContextService;
import ru.ilb.filedossier.entities.DossierContext;

public class DossierContextEditor {
    private DossierContextService contextService;
    private DossierContext context;
    private String contextKey;

    public DossierContextEditor(DossierContextService service) {
        this.contextService = service;
    }

    public void putProperty(String propertyKey, Object propertyValue, String contextKey) {
        this.contextKey = contextKey;
        this.context = this.contextService.getContext(contextKey);
        this.context.setProperty(propertyKey, propertyValue);
    }

    public Optional<Object> getProperty(String propertyKey, String contextKey) {
        this.contextKey = contextKey;
        this.context = this.contextService.getContext(contextKey);
        return Optional.ofNullable(this.context.asMap().get(propertyKey));
    }

    public void commit() {
        this.contextService.putContext(this.contextKey, this.context);
        this.context = null;
        this.contextKey = null;
    }
}

