/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierFileVersion;
import ru.ilb.filedossier.entities.DossierPath;
import ru.ilb.filedossier.entities.Representation;
import ru.ilb.filedossier.entities.Store;
import ru.ilb.filedossier.mimetype.MimeTypeUtil;
import ru.ilb.filedossier.representation.IdentityRepresentation;

public class ConcreteDossierFileVersion
implements DossierFileVersion {
    private DossierFile parent;
    private Store store;
    private String mediaType;
    private Map<String, Representation> representations;
    private Representation defaultRepresentation;

    ConcreteDossierFileVersion(String mediaType, List<Representation> representations) {
        this.mediaType = mediaType;
        this.representations = representations.stream().peek(r -> r.setParent((DossierPath)this)).collect(Collectors.toMap(r -> r.getMediaType(), r -> r, (x, y) -> y, LinkedHashMap::new));
        if (!this.representations.containsKey(mediaType)) {
            IdentityRepresentation identityRepresentation = new IdentityRepresentation(mediaType);
            identityRepresentation.setParent((DossierPath)this);
            this.representations.put(mediaType, (Representation)identityRepresentation);
        }
        this.defaultRepresentation = this.representations.entrySet().iterator().next().getValue();
    }

    public void setContents(byte[] contents) throws IOException {
        this.store.setContents(this.getFileName(), contents);
    }

    public byte[] getContents() throws IOException {
        return this.store.getContents(this.getFileName());
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getExtension() {
        return MimeTypeUtil.getExtension((String)this.mediaType);
    }

    public Representation getRepresentation() {
        return this.defaultRepresentation;
    }

    public Representation getRepresentation(String mediaType) {
        return this.representations.get(mediaType);
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void setMediaType(String mediaType) {
        if (!this.parent.getAllowedMediaTypes().contains(mediaType)) {
            throw new RuntimeException("Setting media type is not allowed: " + mediaType);
        }
        this.mediaType = mediaType;
    }

    public String getCode() {
        return this.parent.getCode();
    }

    public String getName() {
        return this.parent.getName();
    }

    public DossierPath getParent() {
        return this.parent;
    }

    public void setParent(DossierPath parent) {
        assert (DossierFile.class.isAssignableFrom(parent.getClass())) : "Dossier instance should be passed as argument instead of " + parent.getClass().getCanonicalName();
        this.parent = (DossierFile)parent;
    }

    public List<String> getAllowedMediaTypes() {
        return this.representations.values().stream().map(r -> r.getMediaType()).collect(Collectors.toList());
    }

    public Path getFilePath() {
        return this.store.getFilePath(this.getFileName());
    }
}

