/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.core;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import ru.ilb.filedossier.context.DossierContextService;
import ru.ilb.filedossier.core.DossierFileFactory;
import ru.ilb.filedossier.core.DossierImpl;
import ru.ilb.filedossier.ddl.DossierDefinition;
import ru.ilb.filedossier.ddl.DossierDefinitionRepository;
import ru.ilb.filedossier.ddl.DossierFileDefinition;
import ru.ilb.filedossier.ddl.DossierNotFoundException;
import ru.ilb.filedossier.ddl.PackageDefinition;
import ru.ilb.filedossier.entities.Dossier;
import ru.ilb.filedossier.entities.DossierContext;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.Store;
import ru.ilb.filedossier.representation.RepresentationFactory;
import ru.ilb.filedossier.scripting.TemplateEvaluator;
import ru.ilb.filedossier.store.StoreFactory;

@Named
public class DossierFactory {
    private DossierDefinitionRepository dossierDefinitionRepository;
    private StoreFactory storeFactory;
    private RepresentationFactory representationFactory;
    private DossierContextService contextService;
    private String contextRoot;
    private TemplateEvaluator templateEvaluator;

    @Inject
    public DossierFactory(DossierDefinitionRepository dossierDefinitionRepository, StoreFactory storeFactory, DossierContextService contextService) {
        this.dossierDefinitionRepository = dossierDefinitionRepository;
        this.storeFactory = storeFactory;
        this.contextService = contextService;
    }

    public Dossier getDossier(String dossierKey, String dossierPackage, String dossierCode, String dossierMode) {
        this.contextRoot = String.format("%s/%s", dossierKey, dossierCode);
        PackageDefinition dossierPackageDefinition = this.dossierDefinitionRepository.getDossierPackage(dossierPackage, dossierMode);
        DossierDefinition dossierModel = dossierPackageDefinition.getDossiers().stream().filter(d -> d.getCode().equals(dossierCode)).findFirst().orElseThrow(() -> new DossierNotFoundException(dossierCode));
        Store store = this.storeFactory.getStore(dossierKey);
        this.representationFactory = new RepresentationFactory(dossierPackageDefinition.getBaseUri());
        return this.createDossier(dossierModel, store, dossierKey, dossierPackage);
    }

    private Dossier createDossier(DossierDefinition model, Store store, String dossierKey, String dossierPackage) {
        List<DossierFile> dossierFiles = model.getDossierFiles().stream().map(fileModel -> {
            try {
                return this.createDossierFile((DossierFileDefinition)fileModel, store);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while creating dossier file");
            }
        }).collect(Collectors.toList());
        return new DossierImpl(model.getCode(), model.getName(), dossierPackage, dossierKey, dossierFiles);
    }

    private DossierFile createDossierFile(DossierFileDefinition model, Store store) throws IOException {
        DossierContext context = this.contextService.getContext(String.format("%s/%s", this.contextRoot, model.getCode()));
        return DossierFileFactory.createDossierFile(store, this.representationFactory, model, context);
    }
}

