/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.ilb.filedossier.core.ConcreteDossierFileVersion;
import ru.ilb.filedossier.core.DossierFileImpl;
import ru.ilb.filedossier.core.DossierFileVariation;
import ru.ilb.filedossier.ddl.DossierFileDefinition;
import ru.ilb.filedossier.entities.DossierContext;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierFileVersion;
import ru.ilb.filedossier.entities.Store;
import ru.ilb.filedossier.representation.RepresentationFactory;

class DossierFileFactory {
    DossierFileFactory() {
    }

    static DossierFile createDossierFile(Store dossierStore, RepresentationFactory representationFactory, DossierFileDefinition model, DossierContext context) throws IOException {
        List<Object> versions;
        Store dossierFileStore = dossierStore.getNestedFileStore(model.getCode());
        Map<String, DossierFileVariation> variations = model.getVariations().stream().map(variation -> new DossierFileVariation(variation.getMediaType(), variation.getRepresentations().stream().map(arg_0 -> ((RepresentationFactory)representationFactory).createRepresentation(arg_0)).collect(Collectors.toList()))).collect(Collectors.toMap(DossierFileVariation::getMediaType, v -> v));
        if (dossierFileStore.getObjectsCount() > 0) {
            int i;
            ArrayList<String> existingFilesMimeTypes = new ArrayList<String>();
            for (i = 0; i < dossierFileStore.getObjectsCount(); ++i) {
                existingFilesMimeTypes.add(dossierFileStore.getFileMimeType(String.valueOf(i)));
            }
            versions = existingFilesMimeTypes.stream().map(variations::get).map(variation -> new ConcreteDossierFileVersion(variation.getMediaType(), variation.getRepresentations())).collect(Collectors.toList());
            i = 0;
            for (DossierFileVersion dossierFileVersion : versions) {
                Store versionStore = dossierFileStore.getNestedFileStore(String.valueOf(i));
                dossierFileVersion.setStore(versionStore);
                ++i;
            }
        } else {
            versions = new ArrayList();
        }
        return new DossierFileImpl(dossierFileStore, model.getCode(), model.getName(), Boolean.parseBoolean((String)Optional.ofNullable(context.getProperty("required")).orElse(model.getRequired().toString())), Boolean.parseBoolean((String)Optional.ofNullable(context.getProperty("readonly")).orElse(model.getReadonly().toString())), Boolean.parseBoolean((String)Optional.ofNullable(context.getProperty("hidden")).orElse(model.getHidden().toString())), model.isAllowedMultiple(), versions, variations);
    }
}

