/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.core;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.ilb.filedossier.core.ConcreteDossierFileVersion;
import ru.ilb.filedossier.core.DossierFileVariation;
import ru.ilb.filedossier.entities.Dossier;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierFileVersion;
import ru.ilb.filedossier.entities.DossierPath;
import ru.ilb.filedossier.entities.Store;

public class DossierFileImpl
implements DossierFile {
    private Dossier parent;
    private Store store;
    private final String code;
    protected final String name;
    protected final boolean required;
    private final boolean readonly;
    private final boolean hidden;
    private final boolean allowedMultiple;
    private List<DossierFileVersion> versions;
    private Map<String, DossierFileVariation> variations;

    DossierFileImpl(Store store, String code, String name, boolean required, boolean readonly, boolean hidden, boolean allowedMultiple, List<DossierFileVersion> versions, Map<String, DossierFileVariation> variations) {
        this.store = store;
        this.code = code;
        this.name = name;
        this.required = required;
        this.readonly = readonly;
        this.hidden = hidden;
        this.allowedMultiple = allowedMultiple;
        this.variations = variations;
        this.versions = versions.stream().peek(version -> version.setParent((DossierPath)this)).collect(Collectors.toList());
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean getRequired() {
        return this.required;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public boolean getAllowedMultiple() {
        return this.allowedMultiple;
    }

    public boolean getExists() {
        return this.store.getObjectsCount() > 0;
    }

    public String getContextKey() {
        return String.format("%s/%s", this.parent.getContextKey(), this.getCode());
    }

    public LocalDateTime lastModified() {
        return this.store.lastModified(String.valueOf(this.versions.size() - 1));
    }

    public Integer getVersionsCount() {
        return this.store.getObjectsCount();
    }

    public List<String> getAllowedMediaTypes() {
        ArrayList<String> allowedMediaTypes = new ArrayList<String>();
        this.variations.forEach((mt, v) -> allowedMediaTypes.add((String)mt));
        return allowedMediaTypes;
    }

    public DossierFileVersion createNewVersion(String mediaType) {
        if (this.getReadonly()) {
            throw new IllegalArgumentException("Dossier file is readonly: " + this.getCode());
        }
        if (!this.variations.containsKey(mediaType)) {
            throw new IllegalArgumentException("Specified media type '" + mediaType + "' is not allowed");
        }
        DossierFileVariation variation = this.variations.get(mediaType);
        ConcreteDossierFileVersion newVersion = new ConcreteDossierFileVersion(variation.getMediaType(), variation.getRepresentations());
        Store newVersionStore = this.store.getNestedFileStore(String.valueOf(this.versions.size()));
        newVersion.setStore(newVersionStore);
        newVersion.setParent((DossierPath)this);
        return newVersion;
    }

    public DossierFileVersion getVersion(int version) {
        return this.versions.get(version - 1);
    }

    public DossierFileVersion getLatestVersion() {
        if (this.versions.size() > 0) {
            return this.versions.get(this.versions.size() - 1);
        }
        return null;
    }

    public Dossier getParent() {
        return this.parent;
    }

    public void setParent(DossierPath parent) {
        assert (Dossier.class.isAssignableFrom(parent.getClass())) : "Dossier instance should be passed as argument instead of " + parent.getClass().getCanonicalName();
        this.parent = (Dossier)parent;
    }

    public byte[] getContents() throws IOException {
        return this.getLatestVersion().getContents();
    }

    public void setContents(byte[] contents) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getMediaType() {
        return this.getLatestVersion().getMediaType();
    }

    public String getExtension() {
        return this.getLatestVersion().getExtension();
    }
}

