/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.ilb.filedossier.core.DossierFileNotFoundException;
import ru.ilb.filedossier.entities.Dossier;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierPath;

public class DossierImpl
implements Dossier {
    private Dossier parent;
    private Map<String, DossierFile> dossierFiles = new LinkedHashMap<String, DossierFile>();
    private final String code;
    private final String name;
    private final String contextRoot;

    public DossierImpl(String code, String name, String dossierPackage, String dossierKey) {
        this.code = code;
        this.name = name;
        this.contextRoot = String.format("%s/%s", dossierKey, code);
    }

    public DossierImpl(String code, String name, String dossierPackage, String dossierKey, List<DossierFile> dossierFiles) {
        this.code = code;
        this.name = name;
        this.dossierFiles = dossierFiles.stream().peek(df -> df.setParent((DossierPath)this)).collect(Collectors.toMap(DossierPath::getCode, df -> df));
        this.contextRoot = String.format("%s/%s", dossierKey, code);
    }

    public boolean isValid() {
        ArrayList dossierFilesValids = new ArrayList();
        this.dossierFiles.forEach((name, dossierFile) -> dossierFilesValids.add(true));
        return dossierFilesValids.stream().filter(dossierFileValid -> dossierFileValid == false).findFirst().orElse(true);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public List<DossierFile> getDossierFiles() {
        return new ArrayList<DossierFile>(this.dossierFiles.values());
    }

    public String getContextKey() {
        return this.contextRoot;
    }

    public DossierFile getDossierFile(String fileCode) {
        DossierFile file = this.dossierFiles.get(fileCode);
        if (file == null) {
            throw new DossierFileNotFoundException(fileCode);
        }
        return file;
    }

    public Dossier getParent() {
        return this.parent;
    }

    public void setParent(DossierPath parent) {
        assert (Dossier.class.isAssignableFrom(parent.getClass())) : "Dossier instance should be passed as argument instead of " + parent.getClass().getCanonicalName();
        this.parent = (Dossier)parent;
    }
}

