/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.ddl;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import ru.ilb.filedossier.ddl.DossierDefinitionRepository;
import ru.ilb.filedossier.ddl.DossierPackageNotFoundException;
import ru.ilb.filedossier.ddl.PackageDefinition;
import ru.ilb.filedossier.ddl.reader.DossierReader;
import ru.ilb.filedossier.ddl.reader.XmlDossierReader;
import ru.ilb.filedossier.ddl.reader.XsltDossierReader;
import ru.ilb.filedossier.utils.FSUtils;

public class FileDossierDefinitionRepository
implements DossierDefinitionRepository {
    private final URI dossierModelsBaseUri;
    private static final List<DossierReader> DOSSIER_READERS = Arrays.asList(new XmlDossierReader(), new XsltDossierReader());

    public FileDossierDefinitionRepository(URI dossierModelsBaseUri) {
        this.dossierModelsBaseUri = FSUtils.loadFileSystemProvider((URI)dossierModelsBaseUri);
    }

    private Path getDossierPackageBase(String dossierPackage) {
        return Paths.get(this.dossierModelsBaseUri).resolve(dossierPackage);
    }

    private Path getDossierDefinitionPath(String dossierPackage, String extension) {
        return this.getDossierPackageBase(dossierPackage).resolve(dossierPackage + extension);
    }

    private DossierReader getDossierReader(String dossierPackage) {
        return DOSSIER_READERS.stream().filter(dr -> Files.exists(this.getDossierDefinitionPath(dossierPackage, dr.modelFileExtension()), new LinkOption[0])).findFirst().orElseThrow(() -> new DossierPackageNotFoundException(dossierPackage));
    }

    @Override
    public PackageDefinition getDossierPackage(String dossierPackage, String dossierMode) {
        try {
            DossierReader dossierReader = this.getDossierReader(dossierPackage);
            Path dossierPath = this.getDossierDefinitionPath(dossierPackage, dossierReader.modelFileExtension());
            String source = new String(Files.readAllBytes(dossierPath));
            PackageDefinition dossierPackageDefinition = dossierReader.read(source, dossierMode);
            dossierPackageDefinition.setBaseUri(dossierPath.toUri());
            return dossierPackageDefinition;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

