
package ru.ilb.filedossier.ddl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Модель файла досье
 * 
 * <p>Java class for dossierFile complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="dossierFile"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="code" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="readonly" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="required" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="hidden" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="allowedMultiple" type="{http://www.w3.org/2001/XMLSchema}boolean"/&gt;
 *         &lt;element name="attribute" type="{urn:ru:ilb:filedossier:ddl}attribute" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="variation" type="{urn:ru:ilb:filedossier:ddl}variation" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "dossierFile", propOrder = {
    "code",
    "name",
    "readonly",
    "required",
    "hidden",
    "allowedMultiple",
    "attributes",
    "variations"
})
@XmlRootElement(name = "dossierFile")
public class DossierFileDefinition
    implements Serializable
{

    /**
     * Код файла
     * 
     */
    @XmlElement(required = true)
    protected String code;
    /**
     * Наименование
     * 
     */
    @XmlElement(required = true)
    protected String name;
    /**
     * Только для чтения
     * 
     */
    protected Boolean readonly;
    /**
     * Обязательный файл
     * 
     */
    protected Boolean required;
    /**
     * Скрытый файл
     * 
     */
    protected Boolean hidden;
    /**
     * Разрешена ли загрузка множественных файлов
     * 
     */
    protected boolean allowedMultiple;
    /**
     * Аттрибуты документа
     * 
     */
    @XmlElement(name = "attribute")
    protected List<AttributeDefinition> attributes;
    /**
     * Представления файла
     * 
     */
    @XmlElement(name = "variation", required = true)
    protected List<Variation> variations;

    /**
     * Gets the value of the code property.
     * <p>
     * Код файла
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCode() {
        return code;
    }

    /**
     * Sets the value of the code property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCode()
     */
    public void setCode(String value) {
        this.code = value;
    }

    /**
     * Gets the value of the name property.
     * <p>
     * Наименование
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the readonly property.
     * <p>
     * Только для чтения
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getReadonly() {
        return readonly;
    }

    /**
     * Sets the value of the readonly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #getReadonly()
     */
    public void setReadonly(Boolean value) {
        this.readonly = value;
    }

    /**
     * Gets the value of the required property.
     * <p>
     * Обязательный файл
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRequired() {
        return required;
    }

    /**
     * Sets the value of the required property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #getRequired()
     */
    public void setRequired(Boolean value) {
        this.required = value;
    }

    /**
     * Gets the value of the hidden property.
     * <p>
     * Скрытый файл
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getHidden() {
        return hidden;
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #getHidden()
     */
    public void setHidden(Boolean value) {
        this.hidden = value;
    }

    /**
     * Gets the value of the allowedMultiple property.
     * <p>
     * Разрешена ли загрузка множественных файлов
     * 
     */
    public boolean isAllowedMultiple() {
        return allowedMultiple;
    }

    /**
     * Sets the value of the allowedMultiple property.
     * 
     * @see #isAllowedMultiple()
     */
    public void setAllowedMultiple(boolean value) {
        this.allowedMultiple = value;
    }

    /**
     * Gets the value of the attributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AttributeDefinition }
     * 
     * <p>
     * Аттрибуты документа
     * 
     */
    public List<AttributeDefinition> getAttributes() {
        if (attributes == null) {
            attributes = new ArrayList<AttributeDefinition>();
        }
        return this.attributes;
    }

    /**
     * Gets the value of the variations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the variations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVariations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Variation }
     * 
     * <p>
     * Представления файла
     * 
     */
    public List<Variation> getVariations() {
        if (variations == null) {
            variations = new ArrayList<Variation>();
        }
        return this.variations;
    }

    public void setAttributes(List<AttributeDefinition> value) {
        this.attributes = value;
    }

    public void setVariations(List<Variation> value) {
        this.variations = value;
    }

    public DossierFileDefinition withCode(String value) {
        setCode(value);
        return this;
    }

    public DossierFileDefinition withName(String value) {
        setName(value);
        return this;
    }

    public DossierFileDefinition withReadonly(Boolean value) {
        setReadonly(value);
        return this;
    }

    public DossierFileDefinition withRequired(Boolean value) {
        setRequired(value);
        return this;
    }

    public DossierFileDefinition withHidden(Boolean value) {
        setHidden(value);
        return this;
    }

    public DossierFileDefinition withAllowedMultiple(boolean value) {
        setAllowedMultiple(value);
        return this;
    }

    public DossierFileDefinition withAttributes(AttributeDefinition... values) {
        if (values!= null) {
            for (AttributeDefinition value: values) {
                getAttributes().add(value);
            }
        }
        return this;
    }

    public DossierFileDefinition withAttributes(Collection<AttributeDefinition> values) {
        if (values!= null) {
            getAttributes().addAll(values);
        }
        return this;
    }

    public DossierFileDefinition withVariations(Variation... values) {
        if (values!= null) {
            for (Variation value: values) {
                getVariations().add(value);
            }
        }
        return this;
    }

    public DossierFileDefinition withVariations(Collection<Variation> values) {
        if (values!= null) {
            getVariations().addAll(values);
        }
        return this;
    }

    public DossierFileDefinition withAttributes(List<AttributeDefinition> value) {
        setAttributes(value);
        return this;
    }

    public DossierFileDefinition withVariations(List<Variation> value) {
        setVariations(value);
        return this;
    }

}
