
package ru.ilb.filedossier.ddl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for variation complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="variation"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="mediaType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="representation" type="{urn:ru:ilb:filedossier:ddl}representation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "variation", propOrder = {
    "mediaType",
    "representations"
})
public class Variation
    implements Serializable
{

    @XmlElement(required = true)
    protected String mediaType;
    @XmlElement(name = "representation")
    protected List<RepresentationDefinition> representations;

    /**
     * Gets the value of the mediaType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMediaType() {
        return mediaType;
    }

    /**
     * Sets the value of the mediaType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMediaType(String value) {
        this.mediaType = value;
    }

    /**
     * Gets the value of the representations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the representations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRepresentations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RepresentationDefinition }
     * 
     * 
     */
    public List<RepresentationDefinition> getRepresentations() {
        if (representations == null) {
            representations = new ArrayList<RepresentationDefinition>();
        }
        return this.representations;
    }

    public void setRepresentations(List<RepresentationDefinition> value) {
        this.representations = value;
    }

    public Variation withMediaType(String value) {
        setMediaType(value);
        return this;
    }

    public Variation withRepresentations(RepresentationDefinition... values) {
        if (values!= null) {
            for (RepresentationDefinition value: values) {
                getRepresentations().add(value);
            }
        }
        return this;
    }

    public Variation withRepresentations(Collection<RepresentationDefinition> values) {
        if (values!= null) {
            getRepresentations().addAll(values);
        }
        return this;
    }

    public Variation withRepresentations(List<RepresentationDefinition> value) {
        setRepresentations(value);
        return this;
    }

}
