/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.ddl.reader;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import ru.ilb.filedossier.ddl.PackageDefinition;
import ru.ilb.filedossier.ddl.reader.DossierReader;

public class XmlDossierReader
implements DossierReader {
    public static final String MODEL_FILE_EXTENSION = ".xml";
    private static final String URI_2001_SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final String MODEL_SCHEMA_XSD_PATH = "schemas/filedossier/ddl.xsd";
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final Schema SCHEMA;
    private static final JAXBContext JAXB_CONTEXT;

    @Override
    public PackageDefinition read(String source, String dossierMode) {
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            unmarshaller.setSchema(SCHEMA);
            PackageDefinition dossierPackageDefinition = (PackageDefinition)unmarshaller.unmarshal((Reader)new StringReader(source));
            return dossierPackageDefinition;
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String modelFileExtension() {
        return MODEL_FILE_EXTENSION;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)"ru.ilb.filedossier.ddl");
            SCHEMA = SCHEMA_FACTORY.newSchema(DossierReader.class.getClassLoader().getResource(MODEL_SCHEMA_XSD_PATH));
        }
        catch (JAXBException | SAXException ex) {
            throw new RuntimeException(ex);
        }
    }
}

