/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.ddl.reader;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ru.ilb.filedossier.ddl.PackageDefinition;
import ru.ilb.filedossier.ddl.reader.DossierReader;
import ru.ilb.filedossier.ddl.reader.XmlDossierReader;

public class XsltDossierReader
implements DossierReader {
    public static final String MODEL_FILE_EXTENSION = ".dossier.xsl";
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final XmlDossierReader xmlDossierReader = new XmlDossierReader();

    @Override
    public PackageDefinition read(String source, String dossierMode) {
        StreamSource stylesheetInputSource = new StreamSource(new StringReader(source));
        StreamSource inputSource = new StreamSource(new StringReader("<context/>"));
        StringWriter sw = new StringWriter();
        StreamResult outputResult = new StreamResult(sw);
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(stylesheetInputSource);
            transformer.setParameter("dossierMode", dossierMode);
            transformer.transform(inputSource, outputResult);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return this.xmlDossierReader.read(sw.toString(), dossierMode);
    }

    @Override
    public String modelFileExtension() {
        return MODEL_FILE_EXTENSION;
    }
}

