/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.document.merger;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ru.ilb.filedossier.document.merger.DocumentMergerFactory;

public class DocumentMergerExecutor {
    private List<byte[]> documents;
    private DocumentMergerFactory factory = DocumentMergerFactory.getInstance();

    private DocumentMergerExecutor() {
        this.documents = new ArrayList<byte[]>();
    }

    private DocumentMergerExecutor(List<byte[]> documents) {
        this.documents = documents;
    }

    public static DocumentMergerExecutor getInstance() {
        return new DocumentMergerExecutor();
    }

    public static DocumentMergerExecutor fromRawList(List<byte[]> rawDocuments) {
        return new DocumentMergerExecutor(rawDocuments);
    }

    public void addDocumentToMerge(byte[] document, boolean toStart) {
        if (toStart) {
            this.documents.add(0, document);
        } else {
            this.documents.add(document);
        }
    }

    public void addDocumentToMerge(File document, boolean toStart) {
        try {
            this.documents.add(Files.readAllBytes(document.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to add document to merge chain: " + e);
        }
    }

    public static DocumentMergerExecutor fromList(List<File> documents) {
        List<byte[]> rawFiles = documents.stream().map(document -> {
            try {
                return Files.readAllBytes(document.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read incoming files to merge: " + e);
            }
        }).collect(Collectors.toList());
        return DocumentMergerExecutor.fromRawList(rawFiles);
    }

    public byte[] executeMerge() {
        byte[] result = this.documents.get(0);
        this.documents.remove(0);
        for (byte[] document : this.documents) {
            result = this.factory.getDocumentMerger(result, document).apply(result, document);
        }
        return result;
    }
}

