/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.document.merger.functions.image;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.property.AreaBreakType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import ru.ilb.filedossier.document.merger.functions.DocumentMerger;

public class ImagesMerger
implements DocumentMerger {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] apply(byte[] rawImage1, byte[] rawImage2) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            PdfWriter writer = new PdfWriter((OutputStream)os);
            PdfDocument document = new PdfDocument(writer);
            Image image1 = this.buildImage(rawImage1);
            Image image2 = this.buildImage(rawImage2);
            Rectangle rectangle = this.calculateDefaultRectangle(image1, image2);
            Document documentRoot = new Document(document, new PageSize(rectangle));
            ((Document)documentRoot.add(image1.scaleToFit(rectangle.getWidth(), rectangle.getHeight()))).add(new AreaBreak(AreaBreakType.NEXT_PAGE)).add(image2.scaleToFit(rectangle.getWidth(), rectangle.getHeight()));
            document.close();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new DocumentMerger.UnableToMergeDocuments(e);
        }
    }

    private Rectangle calculateDefaultRectangle(Image image1, Image image2) {
        Comparator<Image> comparator = Comparator.comparing(image -> Float.valueOf(image.getImageWidth() * image.getImageHeight()));
        if (comparator.compare(image1, image2) > 0) {
            return new Rectangle((float)((int)image1.getImageWidth()), (float)((int)image1.getImageHeight()));
        }
        return new Rectangle((float)((int)image2.getImageWidth()), (float)((int)image2.getImageHeight()));
    }

    private Image buildImage(byte[] rawImage) {
        ImageData imageData = ImageDataFactory.create((byte[])rawImage);
        return new Image(imageData).setFixedPosition(0.0f, 0.0f);
    }
}

