/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.filesystems.pdf;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Objects;
import java.util.Set;
import ru.ilb.containeraccessor.core.ContainerAccessor;
import ru.ilb.filedossier.filesystems.pdf.PdfFileSystemProvider;
import ru.ilb.filedossier.filesystems.pdf.PdfPath;

public class PdfFileSystem
extends FileSystem {
    private final FileSystemProvider provider;
    private final URI uri;
    private final ContainerAccessor containerAccessor;

    public PdfFileSystem(PdfFileSystemProvider provider, URI uri, ContainerAccessor containerAccessor) {
        this.provider = provider;
        this.uri = uri;
        this.containerAccessor = containerAccessor;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return null;
    }

    @Override
    public Path getPath(String first, String ... more) {
        String path;
        if (more.length == 0) {
            path = first;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            for (String segment : more) {
                if (segment.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(this.getSeparator());
                }
                sb.append(segment);
            }
            path = sb.toString();
        }
        return new PdfPath(this, path);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return null;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return null;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return null;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return null;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return null;
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Objects.hashCode(this.uri);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdfFileSystem other = (PdfFileSystem)obj;
        return Objects.equals(this.uri, other.uri);
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getContentsPath() throws IOException {
        return this.containerAccessor.getContentsPath();
    }

    @Override
    public void close() throws IOException {
        this.containerAccessor.close();
    }
}

