/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.filesystems.pdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.ilb.containeraccessor.core.ContainerAccessorFactory;
import ru.ilb.filedossier.filesystems.pdf.PdfFileSystem;
import ru.ilb.filedossier.filesystems.pdf.PdfPath;

public class PdfFileSystemProvider
extends FileSystemProvider {
    private final Map<URI, PdfFileSystem> fscache = new HashMap<URI, PdfFileSystem>();
    private final ContainerAccessorFactory containerAccessorFactory = new ContainerAccessorFactory();

    @Override
    public void copy(Path fileFrom, Path fileTo, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(Path dir) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        try {
            return this.getPdfFs(uri, true);
        }
        catch (URISyntaxException ex) {
            throw new FileSystemNotFoundException(uri.toString());
        }
    }

    @Override
    public Path getPath(URI uri) {
        try {
            PdfFileSystem host = this.getPdfFs(uri, true);
            return new PdfPath(host, uri.getPath());
        }
        catch (URISyntaxException e) {
            throw new FileSystemNotFoundException(uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdfFileSystem getPdfFs(URI uri, boolean create) throws URISyntaxException {
        Map<URI, PdfFileSystem> map = this.fscache;
        synchronized (map) {
            PdfFileSystem fs = this.fscache.get(uri);
            if (fs == null && create) {
                URI fileUri = URI.create(uri.toString().substring(6));
                fs = new PdfFileSystem(this, uri, this.containerAccessorFactory.getContainerAccessor(fileUri));
                this.fscache.put(uri, fs);
            }
            return fs;
        }
    }

    @Override
    public String getScheme() {
        return "pdffs";
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        PdfFileSystem pfs = (PdfFileSystem)path.getFileSystem();
        Path contentsPath = pfs.getContentsPath().resolve(path.toString().substring(1));
        contentsPath.getFileSystem().provider().checkAccess(contentsPath, modes);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        PdfFileSystem pfs = (PdfFileSystem)path.getFileSystem();
        Path contentsPath = pfs.getContentsPath().resolve(path.toString().substring(1));
        return Files.newByteChannel(contentsPath, StandardOpenOption.READ);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path arg0, DirectoryStream.Filter<? super Path> arg1) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        try {
            return this.getPdfFs(uri, true);
        }
        catch (URISyntaxException e) {
            throw new FileSystemException(e.toString());
        }
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        PdfFileSystem pfs = (PdfFileSystem)path.getFileSystem();
        Path contentsPath = pfs.getContentsPath().resolve(path.toString().substring(1));
        return contentsPath.getFileSystem().provider().readAttributes(contentsPath, type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path arg0, String arg1, LinkOption ... arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path arg0, String arg1, Object arg2, LinkOption ... arg3) throws IOException {
        throw new UnsupportedOperationException();
    }
}

