/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.filesystems.pdf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import ru.ilb.filedossier.filesystems.pdf.PdfFileSystem;

public class PdfPath
implements Path {
    private static final String NEED_TO_BE_AN_INSTANCE_OF_Pdf_PATH = "Need to be an instance of PdfPath";
    private static final String PARENT_PATH = "..";
    private static final String PATH_SEP = "/";
    private static final String DEFAULT_ROOT_PATH = "/";
    private final String path;
    private final PdfFileSystem fileSystem;

    PdfPath(PdfFileSystem fileSystem, String path) {
        String p;
        this.fileSystem = fileSystem;
        this.path = path == null ? "/" : (!(p = path.trim()).startsWith("/") ? "/" + p : p);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public Path getRoot() {
        if (this.path.equals("/")) {
            return this;
        }
        return new PdfPath(this.fileSystem, "/");
    }

    @Override
    public boolean isAbsolute() {
        return this.path.length() > 0 && this.path.startsWith("/");
    }

    @Deprecated
    public String getPathString() {
        return this.path;
    }

    @Override
    public int compareTo(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean endsWith(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean endsWith(String other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path getFileName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path getName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNameCount() {
        return 0;
    }

    @Override
    public Path getParent() {
        int lastSep;
        if (this.path.equals("/")) {
            return null;
        }
        String p1 = this.path;
        if (p1.endsWith("/")) {
            p1 = p1.substring(0, p1.length() - 1);
        }
        if ((lastSep = p1.lastIndexOf("/")) > 0) {
            String parentString = p1.substring(0, lastSep + 1);
            return new PdfPath(this.fileSystem, parentString);
        }
        return null;
    }

    @Override
    public Iterator<Path> iterator() {
        LinkedList<PdfPath> plist = new LinkedList<PdfPath>();
        for (Path p = this; p != null; p = p.getParent()) {
            plist.add(0, (PdfPath)p);
        }
        return plist.iterator();
    }

    @Override
    public Path normalize() {
        try {
            URI normal = new URI(this.path).normalize();
            return new PdfPath(this.fileSystem, normal.getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(this.path, e);
        }
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path relativize(Path other) {
        int j;
        int i;
        if (!(other instanceof PdfPath)) {
            throw new IllegalArgumentException(NEED_TO_BE_AN_INSTANCE_OF_Pdf_PATH);
        }
        if (!other.getFileSystem().equals(this.getFileSystem())) {
            throw new IllegalArgumentException("Wrong File System Type");
        }
        PdfPath base = this;
        PdfPath current = (PdfPath)other;
        String[] bParts = this.path.split("/");
        String[] cParts = current.path.split("/");
        if (bParts.length > 0 && !base.toString().endsWith("/")) {
            bParts = Arrays.copyOf(bParts, bParts.length - 1);
        }
        for (i = 0; i < bParts.length && i < cParts.length && bParts[i].equals(cParts[i]); ++i) {
        }
        StringBuilder sb = new StringBuilder();
        for (j = 0; j < bParts.length - i; ++j) {
            sb.append("/");
        }
        for (j = i; j < cParts.length; ++j) {
            if (j != i) {
                sb.append("/");
            }
            sb.append(cParts[j]);
        }
        return new PdfPath(this.fileSystem, sb.toString());
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Path resolve(String other) {
        if (other.startsWith("/")) {
            throw new IllegalArgumentException(other);
        }
        StringBuilder resolvedPath = new StringBuilder(this.path);
        if (!this.path.endsWith("/")) {
            resolvedPath.append("/");
        }
        resolvedPath.append(other);
        return new PdfPath(this.fileSystem, resolvedPath.toString());
    }

    @Override
    public Path resolveSibling(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path resolveSibling(String other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean startsWith(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean startsWith(String other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path subpath(int beginIndex, int endindex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toUri() {
        return URI.create(this.path);
    }

    @Override
    public String toString() {
        return this.path;
    }
}

