/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.functions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import ru.ilb.filedossier.functions.BadCommandResponseException;
import ru.ilb.filedossier.functions.MapFunction;

public class MapRuntimeFunction
implements MapFunction {
    private final URI commandUri;
    private Process p;
    private final JsonMapObjectReaderWriter jsonreaderwriter = new JsonMapObjectReaderWriter();

    public MapRuntimeFunction(URI commandUri) {
        this.commandUri = commandUri;
    }

    private void marshall(Map<String, Object> map, OutputStream os) throws FileNotFoundException {
        this.jsonreaderwriter.toJson(new JsonMapObject(map), os);
    }

    private Map<String, Object> unmarshall(InputStream stdout, InputStream stderr) throws IOException {
        try {
            return this.jsonreaderwriter.fromJsonToJsonObject(stdout).asMap();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new BadCommandResponseException(this.commandUri.getPath(), stderr);
        }
    }

    @Override
    public Map<String, Object> apply(Map<String, Object> t) {
        File commandFile = Paths.get(this.commandUri.getPath(), new String[0]).toFile();
        if (!commandFile.exists()) {
            throw new IllegalArgumentException(commandFile.toString() + " does not exists");
        }
        commandFile.setExecutable(true);
        if (!commandFile.canExecute()) {
            throw new IllegalArgumentException(commandFile.toString() + " not executable");
        }
        ProcessBuilder pb = new ProcessBuilder(commandFile.toString());
        Map<String, Object> output = null;
        try {
            this.p = pb.start();
            OutputStream stdin = this.p.getOutputStream();
            this.marshall(t, stdin);
            stdin.close();
            InputStream stdout = this.p.getInputStream();
            InputStream stderr = this.p.getErrorStream();
            output = this.unmarshall(stdout, stderr);
            stdout.close();
            int exitCode = this.p.waitFor();
            switch (exitCode) {
                case 127: {
                    throw new IllegalArgumentException(commandFile.toString() + " does not exist");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong command exit code");
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return output;
    }
}

