/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.functions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import ru.ilb.filedossier.functions.ByteFunction;

public class RuntimeFunction
implements ByteFunction {
    private final String[] command;
    private Process p;

    public RuntimeFunction(URI command) {
        File commandFile = Paths.get(command.getPath(), new String[0]).toFile();
        if (!commandFile.exists()) {
            throw new IllegalArgumentException(commandFile.toString() + " does not exists");
        }
        if (!commandFile.canExecute()) {
            throw new IllegalArgumentException(commandFile.toString() + " not executable");
        }
        this.command = new String[]{commandFile.toString()};
    }

    public RuntimeFunction(String ... command) {
        this.command = command;
    }

    @Override
    public byte[] apply(byte[] t) {
        ProcessBuilder pb = new ProcessBuilder(this.command);
        byte[] output = null;
        try {
            int nRead;
            this.p = pb.start();
            OutputStream stdin = this.p.getOutputStream();
            stdin.write(t);
            stdin.close();
            InputStream stdout = this.p.getInputStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = stdout.read(data, 0, data.length)) != -1) {
                if (nRead < data.length) {
                    --nRead;
                }
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            output = buffer.toByteArray();
            stdout.close();
            int exitCode = this.p.waitFor();
            switch (exitCode) {
                case 127: {
                    throw new IllegalArgumentException(this.command[0] + " does not exist");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong command exit code");
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return output;
    }
}

