/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.representation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ru.ilb.filedossier.entities.DossierContents;
import ru.ilb.filedossier.entities.DossierPath;
import ru.ilb.filedossier.representation.IdentityRepresentation;
import ru.ilb.filedossier.representation.JsonXmlRepresentation;

public class OdsXsltRepresentation
extends IdentityRepresentation {
    protected final URI stylesheetUri;
    protected final URI templateUri;

    public OdsXsltRepresentation(String mediaType, URI stylesheetUri, URI templateUri) {
        super(mediaType);
        this.stylesheetUri = stylesheetUri;
        this.templateUri = templateUri;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public byte[] getContents() {
        try {
            return OdsXsltRepresentation.prepareContent(this.parent.getContents(), this.stylesheetUri, this.templateUri);
        }
        catch (IOException | TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] prepareContent(byte[] source, URI stylesheetUri, URI templateUri) throws IOException, TransformerException {
        byte[] result;
        HashMap attributes = new HashMap();
        Path tempDir = Files.createTempDirectory("OdsXsltRepresentation", new FileAttribute[0]);
        Path templatePath = tempDir.resolve("template.ods");
        Files.copy(Paths.get(templateUri), templatePath, new CopyOption[0]);
        URI templateUriJar = URI.create("jar:" + templatePath.toUri().toString());
        try (FileSystem zipFileSys = FileSystems.newFileSystem(templateUriJar, attributes);){
            Path path = zipFileSys.getPath("content.xml", new String[0]);
            byte[] content = Files.readAllBytes(path);
            byte[] stylesheet = Files.readAllBytes(Paths.get(stylesheetUri));
            content = OdsXsltRepresentation.processContent(tempDir, source, content, stylesheet);
            Files.delete(path);
            Files.write(path, content, new OpenOption[0]);
            zipFileSys.close();
            result = Files.readAllBytes(templatePath);
        }
        finally {
            Files.walk(tempDir, new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
        }
        return result;
    }

    private static byte[] processContent(Path tempDir, byte[] source, byte[] content, byte[] stylesheet) throws IOException, TransformerException {
        StreamSource aStyleSheetInputSource = new StreamSource(new InputStreamReader(new ByteArrayInputStream(stylesheet)));
        aStyleSheetInputSource.setSystemId(tempDir.resolve("content.xsl").toString());
        Files.write(tempDir.resolve("data.xml"), source, new OpenOption[0]);
        StreamSource aInputSource = new StreamSource(new InputStreamReader(new ByteArrayInputStream(content)));
        File aOutputFile = tempDir.resolve("content.xml").toFile();
        StreamResult aOutputResult = new StreamResult(aOutputFile);
        TransformerFactory aFactory = TransformerFactory.newInstance();
        Transformer aTransformer = aFactory.newTransformer(aStyleSheetInputSource);
        aTransformer.transform(aInputSource, aOutputResult);
        return Files.readAllBytes(aOutputFile.toPath());
    }

    @Override
    public String getExtension() {
        return "ods";
    }

    @Override
    public void setParent(DossierPath parent) {
        assert (DossierContents.class.isAssignableFrom(parent.getClass())) : "DossierContents instance should be passed as argument instead of " + parent.getClass().getCanonicalName();
        DossierContents dossierContents = (DossierContents)parent;
        switch (dossierContents.getMediaType()) {
            case "application/xml": {
                this.parent = dossierContents;
                break;
            }
            case "application/json": {
                JsonXmlRepresentation jsonXmlRepresentation = new JsonXmlRepresentation();
                jsonXmlRepresentation.setParent(parent);
                this.parent = jsonXmlRepresentation;
                break;
            }
            default: {
                throw new IllegalArgumentException("Media type " + dossierContents.getMediaType() + " is unsupported by OdsXsltRepresentation");
            }
        }
    }
}

