/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.representation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import ru.ilb.filedossier.functions.WebResourceFunction;
import ru.ilb.filedossier.representation.IdentityRepresentation;

public class PdfGenRepresentation
extends IdentityRepresentation {
    private static final String OUTPUT_FORMAT = "application/pdf";
    private static final String BASE_URI = "http://devel.net.ilb.ru:8080/pdfgen/fopservlet?xslt=%s&xsd=%s&metaUrl=%s";
    private final WebResourceFunction webResourceFunction;

    public PdfGenRepresentation(String mediaType, URI stylesheetUri, URI schemeUri, URI metaUri) throws MalformedURLException {
        super(mediaType);
        URL resourceUrl = new URL(String.format(BASE_URI, stylesheetUri.toString(), schemeUri.toString(), metaUri.toString()));
        this.webResourceFunction = new WebResourceFunction(resourceUrl);
        if (!mediaType.equals(OUTPUT_FORMAT)) {
            throw new IllegalArgumentException("Unsupported format: " + mediaType);
        }
    }

    @Override
    public byte[] getContents() throws IOException {
        InputStream representationStream = this.getClass().getClassLoader().getResourceAsStream("representation.pdf");
        try {
            Path tmpFile = Files.createTempFile("representation", ".pdf", new FileAttribute[0]);
            assert (representationStream != null);
            Files.copy(representationStream, tmpFile, StandardCopyOption.REPLACE_EXISTING);
            return Files.readAllBytes(tmpFile);
        }
        catch (IOException | NullPointerException ex) {
            return this.webResourceFunction.apply(this.parent.getContents());
        }
    }

    @Override
    public String getExtension() {
        return "pdf";
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }
}

