/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.representation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.SAXException;
import ru.ilb.filedossier.representation.IdentityRepresentation;
import ru.ilb.filedossier.representation.URIResolverImpl;

public class PdfXsltRepresentation
extends IdentityRepresentation {
    private static final String OUTPUT_FORMAT = "application/pdf";
    protected final URI stylesheetUri;
    protected final URI contentUri;
    private static FopFactory fopFactory = null;

    public PdfXsltRepresentation(String mediaType, URI stylesheetUri, URI contentUri) {
        super(mediaType);
        if (!mediaType.equals(OUTPUT_FORMAT)) {
            throw new IllegalArgumentException("Unsupported media type: " + mediaType);
        }
        this.stylesheetUri = stylesheetUri;
        this.contentUri = contentUri;
    }

    @Override
    public byte[] getContents() {
        try {
            return PdfXsltRepresentation.processContent(this.parent.getContents(), this.stylesheetUri, this.contentUri);
        }
        catch (IOException | URISyntaxException | TransformerException | FOPException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] processContent(byte[] source, URI stylesheetUri, URI contentUri) throws IOException, TransformerException, URISyntaxException, FOPException {
        byte[] stylesheet = Files.readAllBytes(Paths.get(stylesheetUri));
        StreamSource stylesheetSource = new StreamSource(new InputStreamReader(new ByteArrayInputStream(stylesheet)));
        stylesheetSource.setSystemId(stylesheetUri.toString());
        byte[] content = Files.readAllBytes(Paths.get(contentUri));
        StreamSource contentSource = new StreamSource(new InputStreamReader(new ByteArrayInputStream(content)));
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(new URIResolverImpl());
        Transformer transformer = factory.newTransformer(stylesheetSource);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        transformer.transform(contentSource, PdfXsltRepresentation.getStreamResult(out));
        return out.toByteArray();
    }

    private static Result getStreamResult(ByteArrayOutputStream out) throws FOPException, TransformerException, IOException {
        if (fopFactory == null) {
            try {
                fopFactory = FopFactory.newInstance((URI)PdfXsltRepresentation.class.getClassLoader().getResource("fop/").toURI(), (InputStream)PdfXsltRepresentation.class.getResourceAsStream("/fop/fopconf.xml"));
            }
            catch (URISyntaxException | SAXException ex) {
                throw new RuntimeException(ex);
            }
        }
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        Fop fop = fopFactory.newFop(OUTPUT_FORMAT, userAgent, (OutputStream)out);
        return new SAXResult(fop.getDefaultHandler());
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getExtension() {
        return "pdf";
    }
}

