/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.representation;

import java.net.MalformedURLException;
import java.net.URI;
import ru.ilb.filedossier.ddl.RepresentationDefinition;
import ru.ilb.filedossier.entities.Representation;
import ru.ilb.filedossier.representation.JsonXmlRepresentation;
import ru.ilb.filedossier.representation.OdsXsltRepresentation;
import ru.ilb.filedossier.representation.PdfGenRepresentation;
import ru.ilb.filedossier.representation.PdfJpegRepresentation;
import ru.ilb.filedossier.representation.XsltHtmlRepresentation;

public class RepresentationFactory {
    private URI definitionUri;

    public RepresentationFactory(URI definitionUri) {
        this.definitionUri = definitionUri;
    }

    public Representation createRepresentation(RepresentationDefinition model) {
        switch (model.getMediaType()) {
            case "application/vnd.oasis.opendocument.spreadsheet": {
                return this.createOdsRepresentation(model);
            }
            case "application/pdf": {
                try {
                    return this.createPdfRepresentation(model);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Bad uri for representation resources: " + e);
                }
            }
            case "application/xml": {
                return new JsonXmlRepresentation();
            }
            case "application/xhtml+xml": {
                return new XsltHtmlRepresentation(this.definitionUri.resolve(model.getStylesheet()));
            }
            case "image/jpeg": {
                return new PdfJpegRepresentation();
            }
        }
        throw new IllegalArgumentException("unsupported media type: " + model.getMediaType());
    }

    private Representation createOdsRepresentation(RepresentationDefinition model) {
        URI stylesheetUri = this.definitionUri.resolve(model.getStylesheet());
        URI templateUri = this.definitionUri.resolve(model.getTemplate());
        return new OdsXsltRepresentation(model.getMediaType(), stylesheetUri, templateUri);
    }

    private Representation createPdfRepresentation(RepresentationDefinition model) throws MalformedURLException {
        URI stylesheetUri = this.definitionUri.resolve(model.getStylesheet());
        URI schema = this.definitionUri.resolve(model.getSchema());
        URI meta = this.definitionUri.resolve(model.getMeta());
        return new PdfGenRepresentation(model.getMediaType(), stylesheetUri, schema, meta);
    }
}

