/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.representation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ru.ilb.filedossier.entities.DossierContents;
import ru.ilb.filedossier.entities.DossierPath;
import ru.ilb.filedossier.representation.IdentityRepresentation;
import ru.ilb.filedossier.representation.JsonXmlRepresentation;
import ru.ilb.filedossier.representation.URIResolverImpl;

public class XsltHtmlRepresentation
extends IdentityRepresentation {
    private static final String MEDIA_TYPE = "application/xhtml+xml";
    private URI stylesheetUri;

    public XsltHtmlRepresentation(URI stylesheetUri) {
        super(MEDIA_TYPE);
        this.stylesheetUri = stylesheetUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getContents() throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] stylesheet = Files.readAllBytes(Paths.get(this.stylesheetUri));
            StreamSource stylesheetSource = new StreamSource(new InputStreamReader(new ByteArrayInputStream(stylesheet)));
            stylesheetSource.setSystemId(this.stylesheetUri.toString());
            StreamSource contentSource = new StreamSource(new InputStreamReader(new ByteArrayInputStream(this.parent.getContents())));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(new URIResolverImpl());
            Transformer transformer = factory.newTransformer(stylesheetSource);
            StreamResult outputResult = new StreamResult(os);
            transformer.transform(contentSource, outputResult);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExtension() {
        return "xhtml";
    }

    @Override
    public void setParent(DossierPath parent) {
        assert (DossierContents.class.isAssignableFrom(parent.getClass())) : "DossierContents instance should be passed as argument instead of " + parent.getClass().getCanonicalName();
        DossierContents dossierContents = (DossierContents)parent;
        switch (dossierContents.getMediaType()) {
            case "application/xml": {
                this.parent = dossierContents;
                break;
            }
            case "application/json": {
                JsonXmlRepresentation jsonXmlRepresentation = new JsonXmlRepresentation();
                jsonXmlRepresentation.setParent(parent);
                this.parent = jsonXmlRepresentation;
                break;
            }
            default: {
                throw new IllegalArgumentException("Media type " + dossierContents.getMediaType() + " is unsupported by OdsXsltRepresentation");
            }
        }
    }
}

