/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.store;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import ru.ilb.filedossier.entities.Store;
import ru.ilb.filedossier.mimetype.MimeTypeUtil;
import ru.ilb.filedossier.store.InvalidFileNameException;

class FileStore
implements Store {
    private static final Predicate FILENAME_PREDICATE = Pattern.compile("(^[\\w\\d\\._-]+$)").asPredicate();
    private final String storeKey;
    private final URI storeRoot;

    public FileStore(URI storeRoot, String storeKey) {
        this.storeKey = storeKey;
        this.storeRoot = URI.create(storeRoot.toString() + "/");
    }

    private Path getStorePath() {
        return Paths.get(this.storeRoot.resolve(this.storeKey));
    }

    private void createStorePath() {
        this.getStorePath().toFile().mkdirs();
    }

    public Path getFilePath(String key) {
        if (!FILENAME_PREDICATE.test(key)) {
            throw new InvalidFileNameException(key);
        }
        return this.getStorePath().resolve(key);
    }

    public void setContents(String key, byte[] contents) throws IOException {
        this.createStorePath();
        Files.write(this.getFilePath(key), contents, new OpenOption[0]);
        Files.setLastModifiedTime(this.getStorePath(), FileTime.fromMillis(new Date().getTime()));
    }

    public byte[] getContents(String key) throws IOException {
        return Files.readAllBytes(this.getFilePath(key));
    }

    public boolean isExist(String key) {
        return this.getFilePath(key).toFile().exists();
    }

    public String toString() {
        return "FileStore{storeKey=" + this.storeKey + ", storeRoot=" + this.storeRoot + '}';
    }

    public FileStore getNestedFileStore(String key) {
        return new FileStore(this.getStorePath().toUri(), key);
    }

    public int getObjectsCount() {
        String[] allObjects = this.getStorePath().toFile().list();
        if (allObjects == null) {
            return 0;
        }
        return allObjects.length;
    }

    public LocalDateTime lastModified(String code) {
        try {
            BasicFileAttributes attrs = Files.readAttributes(this.getFilePath(code), BasicFileAttributes.class, new LinkOption[0]);
            return LocalDateTime.ofInstant(attrs.lastModifiedTime().toInstant(), ZoneId.systemDefault());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFileMimeType(String code) throws IOException {
        Path path = this.getFilePath(code);
        if (Files.isDirectory(path, new LinkOption[0])) {
            File dir = new File(path.toString());
            byte[] firstFileContents = Files.readAllBytes(dir.listFiles()[0].toPath());
            return MimeTypeUtil.guessMimeTypeFromByteArray((byte[])firstFileContents);
        }
        return MimeTypeUtil.guessMimeTypeFromByteArray((byte[])this.getContents(code));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getAllContents() {
        try (Stream<Path> paths = Files.walk(this.getStorePath(), new FileVisitOption[0]).sorted();){
            ArrayList<byte[]> bytes = new ArrayList<byte[]>();
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                try {
                    bytes.add(Files.readAllBytes(path));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while read file: " + e);
                }
            });
            ArrayList<byte[]> arrayList = bytes;
            return arrayList;
        }
        catch (IOException e) {
            return new ArrayList<byte[]>();
        }
    }
}

