/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.filedossier.usecases.upload;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import ru.ilb.filedossier.document.merger.DocumentMergerExecutor;
import ru.ilb.filedossier.entities.DossierFile;
import ru.ilb.filedossier.entities.DossierFileVersion;
import ru.ilb.filedossier.filedossier.usecases.upload.PublishFileNewVersion;
import ru.ilb.filedossier.mimetype.MimeTypeUtil;

@Named
public class PublishFile {
    private PublishFileNewVersion publishNewVersion;
    private DocumentMergerExecutor executor;

    @Inject
    public PublishFile(PublishFileNewVersion publishNewVersion) {
        this.publishNewVersion = publishNewVersion;
    }

    public void publish(File file, DossierFile dossierFile) {
        this.executor = DocumentMergerExecutor.getInstance();
        DossierFileVersion version = dossierFile.getLatestVersion();
        if (version == null) {
            this.publishNewVersion.publish(file, dossierFile);
            return;
        }
        try {
            this.executor.addDocumentToMerge(version.getContents(), false);
            this.executor.addDocumentToMerge(file, false);
            byte[] mergedDocument = this.executor.executeMerge();
            version.setMediaType(MimeTypeUtil.guessMimeTypeFromByteArray((byte[])mergedDocument));
            version.setContents(mergedDocument);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while merging current dossier file with new file", ex);
        }
    }

    public void mergeAndPublish(List<File> files, DossierFile dossierFile) {
        this.executor = DocumentMergerExecutor.fromList(files);
        DossierFileVersion version = dossierFile.getLatestVersion();
        if (version == null) {
            this.publishNewVersion.mergeAndPublish(files, dossierFile);
            return;
        }
        try {
            this.executor.addDocumentToMerge(version.getContents(), true);
            byte[] mergedDocument = this.executor.executeMerge();
            version.setMediaType(MimeTypeUtil.guessMimeTypeFromByteArray((byte[])mergedDocument));
            version.setContents(mergedDocument);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while merging current dossier with new files", ex);
        }
    }
}

