/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;

public final class FSUtils {
    private FSUtils() {
    }

    public static URI loadFileSystemProvider(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!provider.getScheme().equalsIgnoreCase(uri.getScheme())) continue;
                try {
                    provider.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    try {
                        provider.newFileSystem(uri, Collections.emptyMap());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return uri;
    }
}

