/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier.utils;

import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

final class FileSystemProviderInitializer {
    private FileSystemProviderInitializer() {
    }

    public static void customLoadInstalledProviders() {
        try {
            Field loadingProvidersField = FileSystemProvider.class.getDeclaredField("loadingProviders");
            Field installedProvidersField = FileSystemProvider.class.getDeclaredField("installedProviders");
            loadingProvidersField.setAccessible(true);
            installedProvidersField.setAccessible(true);
            loadingProvidersField.set(null, true);
            List<FileSystemProvider> installedProviders = AccessController.doPrivileged(new PrivilegedAction<List<FileSystemProvider>>(){

                @Override
                public List<FileSystemProvider> run() {
                    return FileSystemProviderInitializer.threadClassLoaderInstalledProviders();
                }
            });
            installedProvidersField.set(null, installedProviders);
            loadingProvidersField.set(null, false);
            loadingProvidersField.setAccessible(false);
            installedProvidersField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("The hack didn't work.", e);
        }
    }

    private static List<FileSystemProvider> threadClassLoaderInstalledProviders() {
        ArrayList<FileSystemProvider> list = new ArrayList<FileSystemProvider>();
        FileSystemProvider defaultProvider = FileSystems.getDefault().provider();
        ServiceLoader<FileSystemProvider> sl = ServiceLoader.load(FileSystemProvider.class, ClassLoader.getSystemClassLoader());
        for (FileSystemProvider provider : sl) {
            FileSystemProviderInitializer.addProviderToList(list, provider);
        }
        ServiceLoader<FileSystemProvider> tsl = ServiceLoader.load(FileSystemProvider.class, Thread.currentThread().getContextClassLoader());
        for (FileSystemProvider provider : tsl) {
            FileSystemProviderInitializer.addProviderToList(list, provider);
        }
        list.add(0, defaultProvider);
        return Collections.unmodifiableList(list);
    }

    private static void addProviderToList(List<FileSystemProvider> list, FileSystemProvider provider) {
        String scheme = provider.getScheme();
        if (!"file".equalsIgnoreCase(scheme)) {
            boolean found = false;
            for (FileSystemProvider p : list) {
                if (!p.getScheme().equalsIgnoreCase(scheme)) continue;
                found = true;
                break;
            }
            if (!found) {
                list.add(provider);
            }
        }
    }
}

