/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.filedossier;

import java.net.URI;
import java.nio.file.Paths;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jdbc.repository.config.EnableJdbcRepositories;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import ru.ilb.common.jaxrs.jaxb.JaxbContextResolver;
import ru.ilb.common.jaxrs.json.MOXyJsonProvider;
import ru.ilb.containeraccessor.components.ContainersResource;
import ru.ilb.containeraccessor.components.ContainersResourceImpl;
import ru.ilb.filedossier.context.persistence.DossierContextNamingStrategy;
import ru.ilb.filedossier.ddl.DossierDefinitionRepository;
import ru.ilb.filedossier.ddl.FileDossierDefinitionRepository;
import ru.ilb.filedossier.store.StoreFactory;

@SpringBootApplication
@EnableJdbcRepositories(basePackages={"ru.ilb.filedossier.context.persistence.repositories"})
@ComponentScan
public class Application {
    @Value(value="${ru.bystrobank.apps.filedossier.storeroot}")
    String storeRoot;
    @Value(value="${dossierRepository}")
    String dossierRepository;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public MOXyJsonProvider jsonProvider() {
        return new MOXyJsonProvider();
    }

    @Bean
    public JaxbContextResolver jaxbContextResolver() {
        return new JaxbContextResolver();
    }

    @Bean
    public StoreFactory storeFactory() {
        return StoreFactory.newInstance((URI)URI.create(this.storeRoot));
    }

    @Bean
    public DossierDefinitionRepository dossierDefinitionRepository() {
        return new FileDossierDefinitionRepository(Paths.get(this.dossierRepository, new String[0]).resolve("packages").toUri());
    }

    @Bean
    public ContainersResource containersResource() {
        return new ContainersResourceImpl();
    }

    @Bean
    public LoggingFeature loggingFeature() {
        LoggingFeature lf = new LoggingFeature();
        lf.addBinaryContentMediaTypes("application/vnd.oasis.opendocument.spreadsheet");
        return lf;
    }

    @Bean
    public NamingStrategy namingStrategy() {
        return new DossierContextNamingStrategy();
    }

    @Bean
    public JsonMapObjectProvider jsonMapObjectProvider() {
        return new JsonMapObjectProvider();
    }
}

