/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.jfunction.exception;

import java.util.function.Supplier;
import ru.ilb.jfunction.exception.ExceptionalFunction;
import ru.ilb.jfunction.exception.ExceptionalResourceSupplier;
import ru.ilb.jfunction.exception.RuntimeExceptionFunction;

public abstract class ExceptionalFunctionUtils {
    private ExceptionalFunctionUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R extends AutoCloseable> T tryWithResources(ExceptionalResourceSupplier<R> resourceSupplier, ExceptionalFunction<R, T, Exception> consumer, Supplier<T> fallbackSupplier) {
        try (R resource = resourceSupplier.get();){
            R t = consumer.apply(resource);
            return (T)t;
        }
        catch (Exception e) {
            return fallbackSupplier.get();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R extends AutoCloseable> T tryWithResources(ExceptionalResourceSupplier<R> resourceSupplier, ExceptionalFunction<R, T, Exception> consumer, RuntimeExceptionFunction runtimeExceptionFunction) {
        try (R resource = resourceSupplier.get();){
            R t = consumer.apply(resource);
            return (T)t;
        }
        catch (Exception e) {
            throw runtimeExceptionFunction.apply(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R extends AutoCloseable> T tryWithResources(ExceptionalResourceSupplier<R> resourceSupplier, ExceptionalFunction<R, T, Exception> consumer) {
        try (R resource = resourceSupplier.get();){
            R t = consumer.apply(resource);
            return (T)t;
        }
        catch (Exception e) {
            throw RuntimeExceptionFunction.INSTANCE.apply(e);
        }
    }
}

