package ru.ilb.jfunction.exception;

/**
 * Special supplier that returns an instance of AutoCloseable
 *
 * @author Peter Kurfer
 * @param <R> actual, inherited type of AutoCloseable
 */
@FunctionalInterface
public interface ExceptionalResourceSupplier<R extends AutoCloseable> {

    /**
     * Supplier method - may throw an exception
     *
     * @return AutoCloseable instance
     * @throws Exception well...don't know why ¯\_(ツ)_/¯
     */
    R get() throws Exception;
}
