/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.ilb.jfunction.map.converters;

import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import ru.ilb.jfunction.marshallers.Marshaller;

@Named
public class ObjectMapToSerializedMapFunctionImpl implements ObjectMapToSerializedMapFunction {

    private final Marshaller marshaller = Marshaller.INSTANCE;

    @Override
    public Map<String, Object> apply(Map<String, Object> context, Map<String, String> contextSignature) {
        return context.entrySet().stream()
                .collect(Collectors.toMap(e -> e.getKey(), e -> marshaller.marshall(e.getValue(), contextSignature.get(e.getKey()))));

    }

}
