/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.jfunction.map.accessors;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import ru.ilb.jfunction.map.accessors.MapAccessor;

@Named
public class MapAccessorImpl
implements MapAccessor {
    private final Map<String, Object> values;

    public MapAccessorImpl(Map<String, Object> values) {
        this.values = values;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.values;
    }

    @Override
    public Object getProperty(String name) {
        return this.values.get(name);
    }

    @Override
    public Map<String, Object> getMapProperty(String name) {
        return (Map)this.getProperty(name);
    }

    @Override
    public String getStringProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public Integer getIntegerProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
        }
        return null;
    }

    @Override
    public Long getLongProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Long ? (Long)value : Long.parseLong(value.toString());
        }
        return null;
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
        }
        return null;
    }

    @Override
    public List<String> getListStringProperty(String name) {
        return (List)this.getProperty(name);
    }
}

