/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.ilb.jfunction.marshallers.map;

import java.util.Map;
import javax.inject.Named;
import org.json.JSONObject;
import org.json.XML;

@Named
public class MapToXmlFunctionImpl implements MapToXmlFunction {

    private final String rootTagName;

    public MapToXmlFunctionImpl(String rootTagName) {
        this.rootTagName = rootTagName;
    }

    public MapToXmlFunctionImpl() {
        this("root");
    }

    @Override
    public String apply(Map<?, ?> t) {
        JSONObject json = new JSONObject(t);
        String xml = XML.toString(json, rootTagName);
        return xml;

    }

}
