/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.ilb.jfunction.marshallers.map;

import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import ru.ilb.jfunction.marshallers.Unmarshaller;

@Named
public class SerializedMapToObjectMapFunctionImpl implements SerializedMapToObjectMapFunction {

    private final Unmarshaller unmarshaller = Unmarshaller.INSTANCE;

    @Override
    public Map<String, Object> apply(Map<String, Object> context, Map<String, String> contextSignature) {
        return context.entrySet().stream()
                .collect(Collectors.toMap(e -> e.getKey(), e -> unmarshaller.unmarshall(e.getValue(), contextSignature.get(e.getKey()))));
    }

}
