/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.ilb.jfunction.marshallers;

/**
 *
 * @author slavb
 */
public interface Marshaller {

    public static Marshaller INSTANCE = new MarshallerImpl();

    /**
     * Marshalls value to required type
     * Boolean, String and Number values marshalled "as is" to skip quoting
     *
     * @param value
     * @return
     */
    Object marshall(Object value);

    /**
     * Marshalls value to required type
     * Boolean, String and Number values marshalled "as is" to skip quoting
     *
     * @param value
     * @param type canonical class name
     * @return
     */
    Object marshall(Object value, String type);

    /**
     * Marshalls value to required type
     * Boolean, String and Number values marshalled "as is" to skip quoting
     *
     * @param value
     * @param type
     * @return
     */
    Object marshall(Object value, Class type);

}
