/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.jfunction.marshallers;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import ru.ilb.jfunction.marshallers.MarshallFunction;
import ru.ilb.jfunction.marshallers.Marshaller;

@Named
public class MarshallerImpl
implements Marshaller {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Map<Class, MarshallFunction> marshallers = new HashMap<Class, MarshallFunction>();
    private final Map<String, MarshallFunction> marshallersString = new HashMap<String, MarshallFunction>();

    public MarshallerImpl() {
        this.marshallers.put(Date.class, d -> DATE_FORMAT.format(d));
        this.marshallers.put(Timestamp.class, d -> DATETIME_FORMAT.format(d));
        this.marshallers.entrySet().forEach(e -> this.marshallersString.put(((Class)e.getKey()).getCanonicalName(), (MarshallFunction)e.getValue()));
    }

    @Override
    public Object marshall(Object value, String type) {
        try {
            Class<?> clazz = type != null ? Class.forName(type) : null;
            return this.marshall(value, clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean marshallTypeAsIs(Class type) {
        return Number.class.isAssignableFrom(type) || Boolean.class == type || String.class == type;
    }

    @Override
    public Object marshall(Object value, Class type) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            type = value.getClass();
        }
        if (this.marshallTypeAsIs(type)) {
            return value;
        }
        MarshallFunction mapper = this.marshallers.get(type);
        if (mapper != null) {
            return mapper.marshall(value);
        }
        return value.toString();
    }

    @Override
    public Object marshall(Object value) {
        return this.marshall(value, (Class)null);
    }
}

