/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.jfunction.marshallers;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import ru.ilb.jfunction.marshallers.UnmarshallFunction;
import ru.ilb.jfunction.marshallers.Unmarshaller;

@Named
public class UnmarshallerImpl
implements Unmarshaller {
    private final Map<Class, UnmarshallFunction> unmarshallers = new HashMap<Class, UnmarshallFunction>();
    private final Map<String, UnmarshallFunction> unmarshallersString = new HashMap<String, UnmarshallFunction>();

    public UnmarshallerImpl() {
        this.unmarshallers.put(String.class, s -> s);
        this.unmarshallers.put(Integer.class, s -> Integer.parseInt(s));
        this.unmarshallers.put(Long.class, s -> Long.parseLong(s));
        this.unmarshallers.put(Double.class, s -> Double.parseDouble(s));
        this.unmarshallers.put(Boolean.class, s -> Boolean.parseBoolean(s));
        this.unmarshallers.put(Timestamp.class, s -> s.length() == 0 ? null : Timestamp.valueOf(s));
        this.unmarshallers.put(java.sql.Date.class, s -> s.length() == 0 ? null : java.sql.Date.valueOf(s));
        this.unmarshallers.put(Date.class, s -> s.length() == 0 ? null : new Date(java.sql.Date.valueOf(s).getTime()));
        this.unmarshallers.entrySet().forEach(e -> this.unmarshallersString.put(((Class)e.getKey()).getCanonicalName(), (UnmarshallFunction)e.getValue()));
    }

    @Override
    public Object unmarshall(Object value, String type) {
        try {
            Class<?> clazz = Class.forName(type);
            return this.unmarshall(value, clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("type " + type + " not found", ex);
        }
    }

    @Override
    public <T> T unmarshall(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        UnmarshallFunction mapper = this.unmarshallers.get(type);
        if (mapper != null) {
            return mapper.apply(value.toString());
        }
        throw new IllegalArgumentException("mapper for type " + type + " not exists");
    }
}

