/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.ilb.jfunction.marshallers;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;

/**
 *
 * @author slavb
 */
@Named
public class UnmarshallerImpl implements Unmarshaller {

    private final Map<Class, UnmarshallFunction> unmarshallers = new HashMap<>();
    private final Map<String, UnmarshallFunction> unmarshallersString = new HashMap<>();

    public UnmarshallerImpl() {
        unmarshallers.put(String.class, s -> s);
        unmarshallers.put(Integer.class, s -> Integer.parseInt(s));
        unmarshallers.put(Long.class, s -> Long.parseLong(s));
        unmarshallers.put(Double.class, s -> Double.parseDouble(s));
        unmarshallers.put(Boolean.class, s -> Boolean.parseBoolean(s));
        unmarshallers.put(java.sql.Timestamp.class, s -> s.length() == 0 ? null : java.sql.Timestamp.valueOf(s));
        unmarshallers.put(java.sql.Date.class, s -> s.length() == 0 ? null : java.sql.Date.valueOf(s));
        unmarshallers.put(java.util.Date.class, s -> s.length() == 0 ? null : new java.util.Date(java.sql.Date.valueOf(s).getTime()));
        // convert to string keys
        unmarshallers.entrySet().forEach(e -> unmarshallersString.put(e.getKey().getCanonicalName(), e.getValue()));
    }

    /**
     * Unmarshalls value to required type
     *
     * @param value
     * @param type
     * @return
     */
    @Override
    public Object unmarshall(Object value, String type) {
        try {
            Class<?> clazz = Class.forName(type);
            return unmarshall(value, clazz);
        } catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("type " + type + " not found", ex);
        }
    }

    /**
     * Unmarshalls value to required type
     *
     * @param <T>
     * @param value
     * @param type
     * @return
     */
    @Override
    public <T> T unmarshall(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T) value;
        }
        UnmarshallFunction<T> mapper = unmarshallers.get(type);
        if (mapper != null) {
            return mapper.apply(value.toString());
        } else {
            throw new IllegalArgumentException("mapper for type " + type + " not exists");
        }
    }
}
