/*
 * Copyright 2020 slavb.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ru.ilb.jfunction.resources;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.net.URL;
import static ru.ilb.jfunction.exception.ExceptionalFunctionUtils.tryWithResources;
import ru.ilb.jfunction.streams.InputStreamToBytesFunction;

@AutoService(URLToBytesFunction.class)
public class URLToBytesFunctionImpl implements URLToBytesFunction {

    @Override
    public byte[] apply(URL input) throws IOException {
        return tryWithResources(input::openStream, InputStreamToBytesFunction.INSTANCE::apply);
    }

}
