package ru.ilb.jfunction.resources;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.net.URL;
import static ru.ilb.jfunction.exception.ExceptionalFunctionUtils.tryWithResources;
import ru.ilb.jfunction.streams.InputStreamToStringFunction;

@AutoService(URLToStringFunction.class)
public class URLToStringFunctionImpl implements URLToStringFunction {

    @Override
    public String apply(URL input) throws IOException {
        return tryWithResources(input::openStream, InputStreamToStringFunction.INSTANCE::apply);
    }

}
